missilecommandlib = require "missilecommand"

function love.load()

  g_images = {}
  -- TODO: Background
  g_images.cursor = love.graphics.newImage("images/cursor.png")
  g_images.base = love.graphics.newImage("images/base.png")
  g_images.city = love.graphics.newImage("images/city.png")

  g_fonts = {}
  g_fonts.default = love.graphics.newFont("fonts/Audiowide-Regular.ttf",18)
  g_fonts.title = love.graphics.newFont("fonts/Audiowide-Regular.ttf",64)
  -- TODO: Fonts - Advanced UI (1/2)
  love.graphics.setFont(g_fonts.default)

  g_music = love.audio.newSource("music/mmc_3.ogg")
  g_music:setLooping(true)
  -- TODO: Music

  g_sounds = {}
  g_sounds.missile_explode =
    love.audio.newSource("sounds/missile_explode.ogg","static")
  -- TODO: Sound Effects (1/3)
  g_sounds.game_status =
    love.audio.newSource("sounds/game_status.ogg","static")
  g_sounds.target_explode =
    love.audio.newSource("sounds/target_explode.ogg","static")

  new_game()

end

function new_game()

  g_mc = missilecommandlib.new()

end

function love.draw()

  -- TODO: Background

  -- TODO: Counter Missiles (1/2)
  draw_missiles(g_mc:get_counter_missiles())
  love.graphics.setColor(255,255,255)

  draw_explosions(g_mc:get_counter_missiles())

  -- TODO: Enemy Missiles
  draw_missiles(g_mc:get_enemy_missiles())
  love.graphics.setColor(255,255,255)

  -- TODO: Cities and Bases (1/3)

  draw_ui()

end

function draw_missiles(missiles)

  for _,missile in pairs(missiles) do
    love.graphics.line(missile.source.x,missile.source.y,missile.current.x,missile.current.y)
  end

end

function draw_targets(targets)

  -- TODO: Cities and Bases (2/3)
    if target.alive then
      if target.type == "base" then
        local mousex,mousey = love.mouse.getPosition()
        local angle = g_mc:find_angle_to_position(target,mousex,mousey)
        -- Targets - Continued
        -- Targets - Continued
        -- Targets - Continued
        love.graphics.draw(g_images.base,target.x,target.y,angle,1,1,32,32)
        -- Targets - Continued
        -- Targets - Continued
      else
        love.graphics.draw(g_images.city,target.x,target.y,0,1,1,32,32)
      end
    end
  -- TODO: Cities and Bases (2/3)
end

function draw_explosions(counter_missiles)

  for _,missile in pairs(counter_missiles) do
    if missile.explode then
      love.graphics.setColor(math.random(255),math.random(255),math.random(255))
      -- TODO: Explosions
    end
  end
  love.graphics.setColor(255,255,255)

end

function draw_ui()

  -- TODO: Fonts - Advanced UI (2/2)
  love.graphics.print("SCORE: "..g_mc:get_score(),32,32)

  if g_mc:is_new_game() then
    love.graphics.setFont(g_fonts.title)

    -- TODO: Title and Score
    -- TODO: Fonts - Advanced UI (2/2)
    -- TODO: Title and Score
  elseif g_mc:is_gameover() then
    love.graphics.setFont(g_fonts.title)
    -- TODO: Title and Score
  end
  love.graphics.setFont(g_fonts.default)

  -- TODO: Cursor
  -- TODO: Cursor

end

function love.update(dt)

  if not g_mc:is_gameover() and not g_mc:is_new_game() then
    g_mc:update_ammo(dt)
    --TODO: Counter Missiles (2/2)
    g_mc:update_enemy_missiles(dt)
    g_mc:update_next_wave(dt)
  end

  if g_mc:is_target_exploding() then
    g_sounds.target_explode:stop()
    g_sounds.target_explode:play()
  end

  if g_mc:is_missile_exploding() then
    g_sounds.missile_explode:stop()
    g_sounds.missile_explode:play()
  end

end

function love.mousepressed(x,y,button)

  -- TODO: Sound Effects (3/3)
  if not g_mc:is_new_game() then
    g_mc:fire_counter_missile(x,y,button)
  end

end

function love.keypressed(key)

  if key == "space" then
    g_sounds.game_status:stop()
    g_sounds.game_status:play()
    if g_mc:is_new_game() then
      g_mc:start_new_game()
    end
    if g_mc:is_gameover() then
      new_game()
    end
  end

end
